<?php

namespace User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'korisnici';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('UserGroup');
	}

	public function groupPermission()
	{
		return $this->belongsTo('GroupPermission');
	}

}