<?php

namespace GroupPermission;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupPermission extends Model 
{

    protected $table = 'permisije_grupa';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group()
    {
        return $this->belongsTo('UserGroup');
    }

    public function permission()
    {
        return $this->belongsTo('Permission');
    }

}