<?php

namespace User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'korisnici';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group()
    {
        return $this->belongsTo('UserGroup');
    }

    public function groupPermission()
    {
        return $this->belongsTo('GroupPermission');
    }

}