<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discount extends Model 
{

    protected $table = 'discount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'code', 'discount_type', 'amount', 'from_date', 'to_date', 'max_uses', 'uses');

    public function branches()
    {
        return $this->belongsToMany('Branch', 'discount_branch', 'discount_id', 'branch_id');
    }

}