<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderService extends Model 
{

    protected $table = 'order_service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('service_id', 'order_id', 'worker_id');

    public function slots()
    {
        return $this->belongsToMany('Slot', 'order_slot', 'order_service_id', 'slot_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function worker()
    {
        return $this->belongsTo('Worker', 'worker_id');
    }

}