<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceBranch extends Model 
{

    protected $table = 'service_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('service_id', 'branch_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}