<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SlotViewHour extends Model 
{

    protected $table = 'slot_view_hour';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slot_hour_id', 'slot_view_id');

    public function hour()
    {
        return $this->belongsTo('SlotHour', 'slot_hour_id');
    }

    public function view()
    {
        return $this->belongsTo('SlotViewHour', 'slot_view_id');
    }

}