<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkerService extends Model 
{

    protected $table = 'worker_service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('worker_id', 'service_id');

    public function worker()
    {
        return $this->belongsTo('Worker', 'worker_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

}