<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountTable extends Migration {

	public function up()
	{
		Schema::create('discount', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('code')->nullable();
			$table->enum('discount_type', array('fixed', 'percent'))->nullable();
			$table->double('amount')->nullable();
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
			$table->integer('max_uses')->nullable();
			$table->integer('uses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('discount');
	}
}