<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatingTable extends Migration {

	public function up()
	{
		Schema::create('rating', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('order_id')->nullable();
			$table->softDeletes();
			$table->string('question1')->nullable();
			$table->string('question2')->nullable();
			$table->string('question3')->nullable();
			$table->string('question4')->nullable();
			$table->string('question5')->nullable();
			$table->integer('total_rate')->nullable();
			$table->boolean('show')->nullable()->default(1);
			$table->string('review')->nullable();
			$table->integer('branch_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rating');
	}
}