<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discount extends Eloquent {

	protected $table = 'discount';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'code', 'discount_type', 'amount', 'from_date', 'to_date', 'max_uses', 'uses');

	public function branches()
	{
		return $this->belongsToMany('Branch', 'discount_branch', 'discount_id', 'branch_id');
	}

}