<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OfferService extends Eloquent {

	protected $table = 'offer_service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('offer_id', 'service_id');

	public function offer()
	{
		return $this->belongsTo('Offer', 'offer_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

}