<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'date', 'type', 'total_duration', 'services_price', 'private_price', 'total_price', 'status', 'offer_id', 'discount_id', 'rating_id', 'branch_id', 'odoo_id');

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

	public function offer()
	{
		return $this->belongsTo('Offer', 'offer_id');
	}

	public function services()
	{
		return $this->hasMany('OrderService', 'order_id');
	}

	public function discount()
	{
		return $this->belongsTo('Discount', 'discount_id');
	}

	public function rating()
	{
		return $this->belongsTo('Rating', 'rating_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}