<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderSlot extends Eloquent {

	protected $table = 'order_slot';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slot_id', 'order_service_id');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function slot()
	{
		return $this->belongsTo('Slot', 'slot_id');
	}

	public function order_service()
	{
		return $this->belongsTo('OrderService', 'order_service_id');
	}

}