<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'price', 'details_en', 'details_ar', 'show', 'category_id', 'brand_id', 'is_new', 'odoo_id');

	public function category()
	{
		return $this->belongsTo('ProductCategory', 'category_id');
	}

	public function brand()
	{
		return $this->belongsTo('Brand', 'brand_id');
	}

	public function branches()
	{
		return $this->belongsToMany('Branch', 'product_branch', 'product_id', 'branch_id');
	}

}