<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SlotViewHour extends Eloquent {

	protected $table = 'slot_view_hour';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slot_hour_id', 'slot_view_id');

	public function hour()
	{
		return $this->belongsTo('SlotHour', 'slot_hour_id');
	}

	public function view()
	{
		return $this->belongsTo('SlotViewHour', 'slot_view_id');
	}

}