<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Worker extends Eloquent {

	protected $table = 'worker';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('branch_id', 'name_en', 'name_ar');

	public function services()
	{
		return $this->belongsToMany('Service', 'worker_service', 'worker_id', 'service_id');
	}

	public function branch()
	{
		return $this->belongsTo('Branch', 'branch_id');
	}

}