<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branch extends Model 
{

    protected $table = 'branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'address_en', 'address_ar', 'phone', 'longitude', 'latitude', 'city_id');

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}