<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'duration', 'price', 'rate', 'details_en', 'details_ar', 'show', 'category_id', 'is_new', 'odoo_id');

    public function category()
    {
        return $this->belongsTo('ServiceCategory', 'category_id');
    }

    public function branches()
    {
        return $this->belongsToMany('Branch', 'service_branch', 'service_id', 'branch_id');
    }

}