<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slot extends Model 
{

    protected $table = 'slot';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'date', 'from_hour', 'to_hour', 'duration', 'max_uses', 'uses');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}