<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SlotView extends Model 
{

    protected $table = 'slot_view';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('day', 'branch_id', 'max_uses');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function hours()
    {
        return $this->belongsToMany('SlotHour', 'slot_view_hour', 'slot_hour_id', 'slot_view_id');
    }

}