<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Worker extends Model 
{

    protected $table = 'worker';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'name_en', 'name_ar');

    public function services()
    {
        return $this->belongsToMany('Service', 'worker_service', 'worker_id', 'service_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}