<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchTable extends Migration {

	public function up()
	{
		Schema::create('branch', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en');
			$table->string('name_ar')->nullable();
			$table->string('address_en')->nullable();
			$table->string('address_ar')->nullable();
			$table->string('phone')->nullable();
			$table->double('longitude')->nullable();
			$table->double('latitude')->nullable();
			$table->integer('city_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('branch');
	}
}