<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlotTable extends Migration {

	public function up()
	{
		Schema::create('slot', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('branch_id')->nullable()->default('1');
			$table->datetime('date')->nullable();
			$table->string('from_hour')->nullable();
			$table->string('to_hour')->nullable();
			$table->enum('duration', array('15', '20', '30', '60'))->nullable();
			$table->integer('max_uses')->nullable();
			$table->integer('uses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('slot');
	}
}