<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkingDayTable extends Migration {

	public function up()
	{
		Schema::create('working_day', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('worker_id')->nullable();
			$table->integer('shift_id')->nullable();
			$table->string('day')->nullable();
			$table->boolean('is_day_off')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('working_day');
	}
}