<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeBannerTable extends Migration {

	public function up()
	{
		Schema::create('home_banner', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('subtitle');
			$table->string('btn_one_text');
			$table->text('btn_one_link');
			$table->string('btn_two_text');
			$table->text('btn_two_link');
			$table->enum('banner_media_type', array('video', 'image'));
			$table->text('banner_media_desktop_path');
			$table->text('banner_media_mobile_path');
			$table->string('banner_media_alt');
			$table->tinyInteger('sort_order');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('home_banner');
	}
}