<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetaTagsTable extends Migration {

	public function up()
	{
		Schema::create('meta_tags', function(Blueprint $table) {
			$table->increments('id');
			$table->text('meta_title');
			$table->text('meta_description');
			$table->text('meta_keywords');
			$table->text('other_meta_tags');
			$table->enum('page', array('about', 'investors', 'nfc', 'mobile_app'));
			$table->text('canonical_url');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('meta_tags');
	}
}