<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Interaction extends Eloquent {

	protected $table = 'interactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('pro_id', 'search_id', 'chat_id', 'interaction_type');

	public function search()
	{
		return $this->hasOne('Search');
	}

	public function attachments()
	{
		return $this->hasMany('Attachment');
	}

}