<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Interaction extends Model 
{

    protected $table = 'interactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('pro_id', 'search_id', 'chat_id', 'interaction_type');

    public function search()
    {
        return $this->hasOne('Search');
    }

    public function attachments()
    {
        return $this->hasMany('Attachment');
    }

}