<?php

namespace App\Models\Project\Project;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = false;
	protected $fillable = array('title', 'description');

	public function completions()
	{
		return $this->morphToMany('Completion', 'completeable');
	}

	public function assignees()
	{
		return $this->morphToMany('Assign', 'assignable');
	}

	public function owner()
	{
		return $this->belongsTo('User', 'user_id', 'owner_id');
	}

	public function tasks()
	{
		return $this->hasManyThrough('Task', 'Activity');
	}

}