<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->integer('owner_id')->unsigned();
			$table->integer('project_id')->unsigned();
			$table->string('title');
			$table->text('description')->nullable();
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
			$table->timestamp('deleted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}