<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OrderTransaction extends Model 
{

    protected $table = 'order_transactions';
    public $timestamps = true;
    protected $fillable = array('order_id', 'client_id', 'client_name', 'client_mobile', 'cost', 'status', 'payment_method');

    public function Order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function Client()
    {
        return $this->belongsTo('User', 'client_id');
    }

}