<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone', 20)->index();
			$table->string('activated', 10)->nullable();
			$table->integer('city_id')->unsigned()->nullable()->index();
			$table->string('image', 30)->nullable();
			$table->string('id_image', 30)->nullable();
			$table->text('about');
			$table->integer('balance');
			$table->enum('type', array('client', 'provider'))->index();
			$table->string('password');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}