<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('provider_times', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_service', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_banks', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_banks', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_transactions', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_transactions', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('provider_transactions', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('provider_transactions', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_id_foreign');
		});
		Schema::table('provider_times', function(Blueprint $table) {
			$table->dropForeign('provider_times_provider_id_foreign');
		});
		Schema::table('provider_service', function(Blueprint $table) {
			$table->dropForeign('provider_service_provider_id_foreign');
		});
		Schema::table('provider_service', function(Blueprint $table) {
			$table->dropForeign('provider_service_service_id_foreign');
		});
		Schema::table('provider_banks', function(Blueprint $table) {
			$table->dropForeign('provider_banks_provider_id_foreign');
		});
		Schema::table('provider_banks', function(Blueprint $table) {
			$table->dropForeign('provider_banks_bank_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_address_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_provider_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_service_id_foreign');
		});
		Schema::table('order_transactions', function(Blueprint $table) {
			$table->dropForeign('order_transactions_order_id_foreign');
		});
		Schema::table('order_transactions', function(Blueprint $table) {
			$table->dropForeign('order_transactions_client_id_foreign');
		});
		Schema::table('provider_transactions', function(Blueprint $table) {
			$table->dropForeign('provider_transactions_provider_id_foreign');
		});
		Schema::table('provider_transactions', function(Blueprint $table) {
			$table->dropForeign('provider_transactions_bank_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
	}
}