<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'activated', 'city_id', 'image', 'id_image', 'about', 'balance', 'type', 'password');

	public function Services()
	{
		return $this->belongsToMany('Service', 'service_id')->withPivot('cost');
	}

	public function ProviderTime()
	{
		return $this->hasOne('ProviderTime', 'provider_id');
	}

	public function Bank()
	{
		return $this->hasMany('ProviderBank', 'provider_id');
	}

	public function City()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function ProviderOrders()
	{
		return $this->hasMany('Order', 'provider_id');
	}

	public function ClientOrders()
	{
		return $this->hasMany('Order', 'client_id');
	}

	public function ProviderTransactions()
	{
		return $this->hasMany('ProviderTransaction', 'provider_id');
	}

	public function OrderTransactions()
	{
		return $this->hasMany('OrderTransaction', 'client_id');
	}

}