<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('barcode');
			$table->string('nama_produk');
			$table->bigIncrements('category_id');
			$table->bigIncrements('unit_id');
			$table->bigIncrements('rack_id');
			$table->integer('min_qty');
			$table->enum('status', array('aktif', 'nonaktif'));
			$table->bigIncrements('author_id');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}