<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsOptionsTable extends Migration {

	public function up()
	{
		Schema::create('products_options', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('name', 255);
			$table->string('title', 255)->nullable();
			$table->string('description', 35)->nullable();
			$table->boolean('live')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products_options');
	}
}