<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function bloodType()
    {
        return $this->belongsTo('Blood_type');
    }

    public function post()
    {
        return $this->belongsToMany('Post');
    }

    public function bloodTypes()
    {
        return $this->belongsToMany('Blood_type');
    }

    public function donationRequest()
    {
        return $this->hasMany('DonationRequest', 'client_id');
    }

    public function contact()
    {
        return $this->hasMany('Contact', 'client_id');
    }

    public function notification()
    {
        return $this->belongsToMany('Notification')withPivot('is_read');
    }

}