<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DonationRequest extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function bloodType()
    {
        return $this->belongsTo('Blood_type');
    }

    public function client()
    {
        return $this->belongsTo('\Client', 'city_id');
    }

    public function notification()
    {
        return $this->hasMany('Notification', 'donation_request_id');
    }

}