<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferPricesTable extends Migration {

	public function up()
	{
		Schema::create('offer_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id');
			$table->integer('store_id');
			$table->decimal('price', 8,2);
			$table->decimal('discount', 8,2)->nullable();
			$table->string('note', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offer_prices');
	}
}