<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('store_id');
			$table->float('price');
			$table->decimal('shipping_value', 8,2)->nullable();
			$table->integer('tax')->nullable();
			$table->string('delivery_status');
			$table->string('payment_status');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('coupon_id')->nullable();
			$table->datetime('delivery_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}