<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomeTable extends Migration {

	public function up()
	{
		Schema::create('income', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('toilet_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('session_id')->unsigned();
			$table->integer('book_id')->unsigned();
			$table->date('date');
			$table->integer('token_start')->unsigned();
			$table->integer('token_end')->unsigned();
			$table->double('cash');
			$table->double('upi');
			$table->double('total');
			$table->enum('entry_type', array('SessionClosed', 'BookClosed'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('income');
	}
}