<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->foreign('car_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commerce', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_user_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_product_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_invoice_id_foreign');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->dropForeign('cards_car_user_id_foreign');
		});
		Schema::table('commerce', function(Blueprint $table) {
			$table->dropForeign('commerce_user_id_foreign');
		});
	}
}