<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCentersTable extends Migration {

	public function up()
	{
		Schema::create('centers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->tinyInteger('type')->default('0');
			$table->string('name', 255);
			$table->integer('status')->default('0');
			$table->string('email', 255)->nullable();
			$table->string('phone')->nullable();
			$table->string('image', 255)->nullable()->default('0');
			$table->integer('region_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('centers');
	}
}