<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestsTable extends Migration {

	public function up()
	{
		Schema::create('quests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('timestamp');
			$table->bigInteger('user_id')->unsigned();
			$table->enum('type', array('daily', 'weekly', 'permanent'));
			$table->integer('value');
			$table->json('content');
			$table->integer('total');
		});
	}

	public function down()
	{
		Schema::drop('quests');
	}
}