<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProvidersTable extends Migration {

	public function up()
	{
		Schema::create('user_providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->enum('provider_type', array('google', 'facebook', 'apple'));
			$table->string('provider_hash');
			$table->string('provider_email');
			$table->string('provider_name');
			$table->string('provider_avatar');
		});
	}

	public function down()
	{
		Schema::drop('user_providers');
	}
}