<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->datetime('email_verified_at')->nullable();
			$table->string('password', 255)->nullable();
			$table->json('roles')->default('["player"]');
			$table->rememberToken();
			$table->softDeletes();
			$table->timestamps();
			$table->bigInteger('subscription_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}