<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Mission extends Eloquent {

	protected $table = 'missions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'objective', 'image', 'tags', 'dificulty', 'practice_blocks', 'challenge_blocks', 'rewards');

	public function practice_blocks()
	{
		return $this->hasMany('App\Mission\Block');
	}

	public function owner()
	{
		return $this->hasOne('App\User');
	}

	public function results()
	{
		return $this->hasMany('App\UserMissionResult');
	}

	public function challenge_blocks()
	{
		return $this->hasMany('App\Mission\Block');
	}

}