<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'email_verified_at', 'password', 'roles');

    public function providers()
    {
        return $this->hasMany('App\UserProvider');
    }

    public function stickers()
    {
        return $this->hasMany('App\Game\Sticker');
    }

    public function roles()
    {
        return $this->hasMany('App\Role');
    }

    public function profile()
    {
        return $this->hasOne('App/Game\UserGlobalStats');
    }

    public function courses()
    {
        return $this->hasMany('App\UserCourse');
    }

    public function subscription()
    {
        return $this->hasOne('App\Subscription');
    }

    public function targets()
    {
        return $this->hasMany('App\Quest');
    }

    public function courseStats()
    {
        return $this->hasMany('App/Game\UserCourseStats');
    }

}