<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('email', 191);
			$table->integer('phone');
			$table->string('password', 191);
			$table->string('image', 191);
			$table->string('social_provider', 191);
			$table->integer('social_id');
			$table->integer('status')->default('1');
			$table->string('social_image', 191);
			$table->integer('store_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->datetime('location_updated_at');
			$table->boolean('is_online');
			$table->integer('rate');
			$table->boolean('in_service');
			$table->datetime('activation_date');
			$table->string('longitude', 191);
			$table->string('latitude', 191);
			$table->timestamps();
			$table->integer('language_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}